'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeRendererProcess = initializeRendererProcess;

var _compilerHost = require('./compiler-host');

var _compilerHost2 = _interopRequireDefault(_compilerHost);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// NB: These are duped in protocol-hook so we can save startup time, make
// sure to run both!
const magicGlobalForRootCacheDir = '__electron_compile_root_cache_dir';
const magicGlobalForAppRootDir = '__electron_compile_app_root_dir';

const d = require('debug')('electron-compile:initialize-renderer');

let rendererInitialized = false;

/**
 * Called by our rigged script file at the top of every HTML file to set up
 * the same compilers as the browser process that created us
 *
 * @private
 */
function initializeRendererProcess(readOnlyMode) {
  if (rendererInitialized) return;

  let rootCacheDir = require('electron').remote.getGlobal(magicGlobalForRootCacheDir);
  let appRoot = require('electron').remote.getGlobal(magicGlobalForAppRootDir);
  let compilerHost = null;

  // NB: This has to be synchronous because we need to block HTML parsing
  // until we're set up
  if (readOnlyMode) {
    d(`Setting up electron-compile in precompiled mode with cache dir: ${rootCacheDir}`);

    // NB: React cares SUPER HARD about this, and this is the earliest place
    // we can set it up to ensure React picks it up correctly
    process.env.NODE_ENV = 'production';
    compilerHost = _compilerHost2.default.createReadonlyFromConfigurationSync(rootCacheDir, appRoot);
  } else {
    d(`Setting up electron-compile in development mode with cache dir: ${rootCacheDir}`);

    var _require = require('./config-parser');

    const createCompilers = _require.createCompilers;

    const compilersByMimeType = createCompilers();

    compilerHost = _compilerHost2.default.createFromConfigurationSync(rootCacheDir, appRoot, compilersByMimeType);
  }

  require('./x-require');
  require('./require-hook').default(compilerHost, readOnlyMode);
  rendererInitialized = true;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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